# Syncar export script
# (C) Zen3.De - Tezen 2012

import pfpy
from pfpy import Tracker, Camera, Group, Mesh

def pfExportName():
    return 'Syncar'

def pfExportExtension():
    return 'syncar'

def pfExportSupport():
    return ('cameras', 'groups', 'solvedTrackers', 'mocap', 'meshes', 'textures')

def getLWOFilename(meshName):
    path = pfpy.getExportFilename().rsplit('/',1)
    return path[0]+'/'+meshName+'.lwo'
 
def main():
    fobj= open(pfpy.getExportFilename(), 'w')

    firstFrame= 0
    lastFrame= 0
    frameRate= 25.0
    objectId= 0x10000000;
    deg2rad= 3.141592654/180.0
    eulOrder= 'xyz'

    # set desired coordinate system
    pfpy.setExportCoordinateSystem('right', 'y')

    if (pfpy.getNumCameras() > 0):
        c= pfpy.getCameraRef(0)
        firstFrame= c.getInPoint()-1
        lastFrame= c.getOutPoint()-1
	numberofFrames= lastFrame-firstFrame+1
        frameRate= c.getFrameRate()
        wid= c.getFrameWidth()
        hei= c.getFrameHeight()

	dl= pfpy.getClipRef(0)
	dn= dl.getFilename('all')
	dn= dn.replace('\\','/')

    firstFrameStr= '%d'%firstFrame;
    lastFrameStr= '%d'%lastFrame;
    numberofFramesStr= '%d'%numberofFrames;

    fobj.write('SynthEyesScene {\n')
    fobj.write('  Imag {\n')
    fobj.write('    Came \"PFcam\"\n')
    fobj.write('    Apth \"'+dn+'\"\n')
    fobj.write('    Rpth \"\"\n')
    fobj.write('    Size '+'%d'%wid+',%d'%hei+'\n')
    fobj.write('    AspK 1.77778\n')
    fobj.write('    Rate '+'%g'%frameRate+'\n')
    fobj.write('    Leng '+numberofFramesStr+'\n')
    fobj.write('    Rang '+firstFrameStr+','+lastFrameStr+'\n')
    fobj.write('    Aper 45\n')
    fobj.write('  }\n')
    fobj.write('  Obje {\n')

    # CAMERAS

    firstCamera= -1

    numCameras= pfpy.getNumCameras()
    idx= 0
    while (idx < numCameras):
        c= pfpy.getCameraRef(idx)

        if (c.getExport()) :

            fobj.write('    Name \"PFcam\"\n')
	    fobj.write('    Came 1\n')
	    fobj.write('    Path {\n')

            inPoint= c.getInPoint()
            outPoint= c.getOutPoint()
            numFrames= 1+outPoint-inPoint

            for i in range(inPoint, outPoint+1, 1):
                p= c.getTranslation(i)
		q= c.getEulerRotation(i,'zxy')
		cou=i-inPoint
		piStr= '%d'%cou
                fobj.write('      PKey '+piStr+',%g'%p[0]+',%g'%p[1]+',%g'%p[2]+',%g'%q[0]+',%g'%q[1]+',%g'%q[2]+'\n')

            fobj.write('    }\n')

            # remember the first camera that is output
            if (firstCamera < 0):
                firstCamera= idx;
	    if (firstCamera >= 0 and pfpy.getNumClips() >= firstCamera):
	        cl= pfpy.getClipRef(firstCamera)
	        if not cl.isQuicktime() :
	            fobj.write('')
	        else:
		    fobj.write('')
        idx += 1

    # TRACKERS

    fobj.write('    Zoom {\n      FKey 0,50.0000\n    }\n')

    numGroups= pfpy.getNumGroups()

    gidx= 0
    while (gidx < numGroups):
        g= pfpy.getGroupRef(gidx)

        numTrackers= g.getNumTrackers()
        if (numTrackers > 0):

            # calculate a suitable null size for this group
            trackerScale= 3.0*g.getNullSize()

            # remember the id for this container object
            trackerGroupId= objectId;
            objectId += 1

            # is this a non-camera group?
            if (not g.isCameraGroup()):

		fobj.write('')

            else:

                fobj.write('')

            # write each tracker in this group
            idx= 0
            while (idx < numTrackers):
                t= g.getTrackerRef(idx)

                if (t.getSolved() and t.getExport()):
                    p= t.getSolvedPos()

                    objectId += 1

                    fobj.write('    Trak {\n      Name \"'+t.getName()+'\"\n')
                    fobj.write('      WPos '+'%g'%p[0]+',%g'%p[1]+',%g'%p[2]+'\n')
                    fobj.write('    }\n')

                    if (t.getMocap()):
                        fobj.write('')
                    else :
                        fobj.write('')


                idx += 1
        gidx += 1
	fobj.write('  }\n}\n')

    fobj.close()


